<?php
function getFullStats()
{
  if(!$this->dbo) return "Statystki nie są dostępne.";

  //Weryfikacja danych
  $ile = -1;
  if(isset($_GET['ile'])){
    $ile = intval($_GET['ile']);
    if($ile >= -1){
      if($ile == 0){
        //Czy zostały przekazane daty?
        if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
          //Czy daty odpowiadają formatowi?
          if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
             !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
            //Niezgodność formatu.
            $ile = -1;
          }
          else{
            //Odczytanie dat.
            $dataOd = $_GET['dataOd'];
            $dataDo = $_GET['dataDo'];
          }
        }
        //Brak dat przy zaznaczonej opcji zakresu.
        else{
          $ile = -1;
        }
      }
      else{
        //Ustalenie maksymalnej dopuszczalnej liczby dni.
        if($ile > 3660) $ile = 3660;
      }
    }
    //Parametr ile był nieprawidłowy.
    else{
      $ile = -1;
    }
  }
  
  //Formowanie warunków zapytań i nagłówka tabeli.
  if($ile == 0){
    //Dodanie warunku dotyczącego dat.
    $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
    $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
  }
  else if($ile > 0){
    //Dodanie warunku dotyczącego wybranego okresu.
    $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
    $statsInfo = "Statystyki z ostatnich $ile dni.";
  }
  else{
    //Dodanie pustego warunku.
    $cond = ' WHERE 1=1 ';
    $statsInfo = "Pełne statystyki";
  }
  
  //Dalsza część metody.
}
?>